<?php defined('SYSPATH') or die('No direct script access.');

class Task_Insert_Client_Info extends Minion_Task{

    protected function _execute(array $params){
        Task_Helper::createWorker('Insert:Client:Info', $this);
    }

    public function Worker(GearmanJob $job){
        $id = false;
        $find = false;
        $data = json_decode($job->workload(), true);

        /* Get Info from admin */
        $client = Task_Helper::getAdminClient();
        $client->setCompleteCallback(function($task) use(&$data, &$find){
            if ($task->data()) {
                $client = json_decode($task->data(), true);
                $find = true;

                $data['prefix'] = $client['name'];
                $data['version'] = $client['client_ver'];
                $data['net'] = $client['group'];
                $data['system'] = $client['sys_ver'];
                $data['ip'] = $client['ip'];
                $data['location'] = $client['country'];
                $data['registered'] = $client['created_at'];
                $data['lastactivity'] = $client['logged_at'];
            }
        });
        $json = json_encode(Arr::extract($data, ['cid0', 'cid1']));
        $client->addTask("ClientInfo", $json, null, md5($json));
        $client->runTasks();

        /* Add client if finded */
        if($find){
            $client = Task_Helper::getClient();
            $client->setCompleteCallback(function($task) use(&$id){
                if ($task->data()) {
                    $id = $task->data();
                }
            });
            $data = json_encode($data);
            $client->addTask("Insert:Client:Add", $data, null, md5($data));
            $client->runTasks();
        }

        return $id;
    }
}